

import Alkindi.Data.*;
import Alkindi.Services.*;
import Alkindi.Services.BeanIface.*;

public class RMTest
{
	IRatingManagerBean rmb = null;

	public RMTest() 
	{
		try {
			rmb = BeanUtil.getRatMgr();	
		}
		catch(Exception e) {
			System.out.println("Exception in RMTest constructor:\n" + e.toString());
		}
	}
	public void finalize()
	{
		try {
			rmb.remove();
		}
		catch(Exception e ) {
			System.out.println("Exception in RMTest finalizer:\n" + e.toString());
			e.printStackTrace();
		}
	}
	
	static void usage() {
		System.out.println("Usage:");
		System.out.println("\tcall with zero or one argument:");
		System.out.println("\t uid -- 	uses a specified user id");
	}

	
	public void getProducts(long uid, int numProds) 
	{
		try {
			SystemUser su = new SystemUser(uid);
			
			ProductList pl = rmb.getProductsToRate(su, numProds);
			if (pl == null) {
				System.out.println("no productList returned.");
				return;
			}
		
			for (int idx = 0; idx < pl.size(); idx ++) {
				Product pr = pl.get(idx);
				System.out.println("Product " + idx + " has id=" + pr.id+ " and type=" + pr.type);
			}
		}
		catch( Exception e) {
			System.out.println(e.toString());
			e.printStackTrace();
		}
	}

	public void rateProducts(long uid, int numProds)
	{
		try {
			SystemUser su = new SystemUser(uid);
			ProductList pl = rmb.getProductsToRate(su, numProds);
			RatingList ratList = new RatingList(su, pl);
			for (int idx = ratList.size(); --idx > -1; ) {
				System.out.println("Rating product " + ratList.get(idx).prod.id);
			}
			System.out.println("Rated " + numProds + " products for user " + uid);
			rmb.rateProducts(ratList);
		}
		catch( Exception e) {
			System.out.println(e.toString());
			e.printStackTrace();
		}
	}
	
	static void main(String[] args) {
		long uid = 0;
	
		
		if ( args.length > 0) {
			if (args[0].compareTo("-h") == 0 || args[0].compareTo("--help") == 0){
				usage();
				System.exit(1);
			}
			uid = Long.parseLong(args[0]);
		}
		RMTest This = new RMTest();
		This.getProducts(uid, 8);


	}





}

